/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.mu;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.ipc.sim.Signal;
import com.cisco.pt.mu.MultiUserMessage;

public class MUPDUMessage
extends MultiUserMessage {
    public int msgId = -1;
    public int linkId = -1;
    public Signal pdu = null;

    public MUPDUMessage() {
        super.setType(PTMP_TYPE_MUPDU);
    }

    public static MUPDUMessage getMessage(EncodedBuffer buffer) {
        MUPDUMessage msg = new MUPDUMessage();
        msg.msgId = buffer.getInt();
        msg.linkId = buffer.getInt();
        msg.pdu = (Signal)IPCResponseFactory.getPDUData(buffer);
        return msg;
    }

    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        buffer.putInt(super.getType());
        buffer.putInt(this.msgId);
        buffer.putInt(this.linkId);
        if (this.pdu != null) {
            this.pdu.encodeTypeAndPayload(buffer);
        }
        buffer.flip();
    }

    public String toString() {
        String str = new String();
        str = "[MUPDUMessage: \n";
        str = str + "    msgId: " + this.msgId + "\n";
        str = str + "   linkId: " + this.linkId + "\n";
        str = str + "      pdu: " + this.pdu + "\n";
        str = str + "]";
        return str;
    }
}

